<?php
/**
 * Copyright © OXID eSales AG. All rights reserved.
 * See LICENSE file for license details.
 */
namespace OxidEsales\EshopCommunity\Tests\Unit\Application\Controller\Admin;

use OxidEsales\EshopCommunity\Application\Model\Delivery;

use \oxTestModules;

/**
 * Tests for Delivery_Articles class
 */
class DeliveryArticlesTest extends \OxidTestCase
{

    /**
     * Delivery_Articles::Render() test case
     *
     * @return null
     */
    public function testRender()
    {
        oxTestModules::addFunction("oxdelivery", "isDerived", "{return true;}");
        $this->setRequestParameter("oxid", "testId");

        // testing..
        $oView = oxNew('Delivery_Articles');
        $this->assertEquals('delivery_articles.tpl', $oView->render());
        $aViewData = $oView->getViewData();
        $this->assertTrue(isset($aViewData['edit']));
        $this->assertTrue($aViewData['edit'] instanceof Delivery);
        $this->assertTrue(isset($aViewData['readonly']));
    }

}
